#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

#check for /etc/enigma2 folder
if [ ! -d /etc/enigma2 ] ; then
	mkdir -p /etc/enigma2
fi

# workaround for corrupt ssl files
if [ ! "$(grep config.misc.firstrun /etc/enigma2/settings)" == "config.misc.firstrun=false" ]; then
	rm -rf /etc/enigma2/cert.pem &
	rm -rf /etc/enigma2/key.pem &
fi

# update NTP time if NTP Time Enabled
if [ "$(grep config.misc.SyncTimeUsing /etc/enigma2/settings)" == "config.misc.SyncTimeUsing=1" ]; then
	/usr/sbin/ntpdate -s -u pool.ntp.org &
fi

if [ -x /usr/bin/showiframe ]; then
	if [ -f /etc/enigma2/backdrop.mvi ]; then
		/usr/bin/showiframe /etc/enigma2/backdrop.mvi
	elif [ -f /usr/share/backdrop.mvi ]; then
		/usr/bin/showiframe /usr/share/backdrop.mvi
	fi
fi

# hook to execute scripts always before enigma2 start
if [ -x /usr/bin/enigma2_pre_start.sh ]; then
	/usr/bin/enigma2_pre_start.sh
fi

if [ -e /proc/stb/info/hwmodel ]; then
   stbcheck=`cat /proc/stb/info/hwmodel | cut -c1-8`
   if [ $stbcheck == "optimuss" ]; then
      string=`mount | grep 'sda1' | cut -d " " -f3`
      if [ -e $string/sat-soft/settings.sh ]; then
         chmod 755 $string/sat-soft/settings.sh
         $string/sat-soft/settings.sh
      fi
   fi
fi

if [ -d /home/root ]; then
	cd /home/root
	export HOME=/home/root
fi

#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

#check for specific pagecache helper lib
if [ -e /usr/lib/libpagecache.so ]; then
	LIBS="$LIBS /usr/lib/libpagecache.so"
fi

#check for receiver specific passthrough helper lib
if [ -e /usr/lib/libpassthrough.so ]; then
	LIBS="$LIBS /usr/lib/libpassthrough.so"
fi

if [ ! -e /etc/enigma2/settings ]; then
	touch /etc/enigma2/settings
fi

#check for default sat settings
stbcheck=00
if [ -e /proc/stb/info/subtype ]; then
   stbcheck=`cat /proc/stb/info/subtype`
fi
if [ -e /etc/defaultsat.tar.gz ] && [ ! -e /etc/enigma2/lamedb ] && [ ! $stbcheck == "01" ] && [ ! $stbcheck == "1" ]; then
	tar -xzf /etc/defaultsat.tar.gz -C /etc/enigma2
fi

sync

# in case sysctl.conf is not properly loaded - load sysctl.conf here again...
sysctl -p

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
        [ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

if [ "$(grep config.crash.enabledebug /etc/enigma2/settings)" == "config.crash.enabledebug=true" ]; then
	RANDOMIZE1970=''
	time=`date +%Y` ;
	if [ "$time" = 1970 ]; then
		RANDOMIZE1970="$(strings /dev/urandom | grep -o '[[:alnum:]]' | head -n 5 | tr -d '\n')"
	fi
	if [ "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" != "" -a -d "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" ]; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2 --debug-no-color &> $(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')Enigma2-debug-$(date +%Y%m%d_%H-%M-%S)$RANDOMIZE1970.log
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2 --debug-no-color &> /home/root/logs/Enigma2-debug-$(date +%Y%m%d_%H-%M-%S)$RANDOMIZE1970.log
	fi
else
	# in case $TERM is "linux" the serial output is activated - discard debug output
	if [ "$TERM" = linux ]; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2 2> /dev/null
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2
	fi
fi

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal

ret=$?
case $ret in
	1)
		/sbin/halt
		;;
	2)
		/sbin/reboot
		;;
	3)
		rm -fR /home/root/.gstreamer-0.10
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	4)
		/sbin/rmmod lcd
		/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
		sleep 1;
		/sbin/rmmod fp
		/sbin/modprobe fp
		/sbin/reboot
		;;
	42)
		python /usr/lib/enigma2/python/upgrade.pyo
		;;
	43)
		init 1
		;;
	44)
		# little hack but it will be fixed soon in drivers
		/usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/bin/fbclear
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/wait.mvi
		echo fpupload >/proc/vfd && sleep 3 && dd bs=256k if=/tmp/micom.bin of=/dev/mcu
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/reboot.mvi
		# Wait forever for the user to power off
		while(true) ; do sleep 60 ; done
		;;
	45)
		echo "    " > /dev/lcd0
		/usr/bin/gigablue_wol
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
