from Plugins.Plugin import PluginDescriptor
from Screens.Screen import Screen
from Components.config import config
from Components.ActionMap import ActionMap
from Components.VolumeControl import VolumeControl

import os, cbcfg, pipc

from enigma import eTimer, fbClass, eRCInput

from pipc import PServerThread, PServerHandlers

from youtube import YoutubeTVWindow, YoutubeTVSettings
from chromium import ChromiumOSWindow, ChromiumOSSettings

_g_launcher_handler = None

pipc._SOCKETFILE = "/tmp/.chromium.sock"
cbcfg.INIT(cbcfg._ERROR)
 
def dvbapp_lock():
	cbcfg.DEBUG("dvbapp_lock")                                                                                                                            
#	fbClass.getInstance().lock()
	eRCInput.getInstance().lock()                                                                                                                              
                                                                                                                                                               
def dvbapp_unlock():                                                                                                                                        
	cbcfg.DEBUG("dvbapp_unlock")                                                                                                                          
#	fbClass.getInstance().unlock()
	eRCInput.getInstance().unlock()

_OPCODES = [ 'CONTROL_EXIT', 'OPCODE_END' ]                                                                          
class BrowserHandlers(PServerHandlers):                                                                                                                     
	def __init__(self):                                                                                                                                        
		PServerHandlers.__init__(self, _OPCODES, '_CBH_')                                                                                                      
		self._cbPlayerExit()                                                                                                                                   
                                                                                                                                                               
	def _cbPlayerExit(self, ret=None):                                                                                                                         
		try:                                                                                                                                                   
			self.playerHandle.playlist.clear()                                                                                                                 
		except: pass                                                                                                                                           
		self.playerHandle = None

	def _CBH_CONTROL_EXIT(self, result, packet):                                                                                                               
        	try:                                                                                                                                                   
			global _g_launcher_handler                                                                                                                         
			if _g_launcher_handler is not None:                                                                                                                
				_g_launcher_handler.Exit()                                                                                                                     
				_g_launcher_handler = None                                                                                                                     
        	except Exception, err:                                                                                                                                 
            		cbcfg.ERROR("%s", err)                                                                                                                           
            		return (False, None)                                                                                                                               
        	return (True, None)

_HANDLER = BrowserHandlers()                                                                                    
class BBrowserLauncher(Screen):
	skin = """<screen name="BBrowserLauncher" position="0,0" size="0,0" backgroundColor="transparent" flags="wfNoBorder" title=" "></screen>"""
	def __init__(self, session, mode=None):
		self.session = session

		Screen.__init__(self, session)
		
		self.isMute = -1		

		self.pServerThread = PServerThread()                                                                                                                
		self.pServerThread.open(timeout = 1)                                                                                                                
		self.pServerThread.start()

		self.closeTimer = eTimer()                                                    
        	self.closeTimer.timeout.get().append(self._cb_CloseTimer)
		
		global _g_launcher_handler                                                                                                                             
        	_g_launcher_handler = self

		cbcfg.g_service = session.nav.getCurrentlyPlayingServiceReference()       
		if cbcfg.g_service is not None:                
			session.nav.stopService()                                                 

		if VolumeControl.instance.volctrl.isMuted() :
			VolumeControl.instance.volctrl.volumeUnMute()
			self.isMute = 1
		else :
			self.isMute = 0

		cbcfg.DEBUG("[Chromium Plugin] ==== >> default mute [%d]" % self.isMute)		

		command = "/usr/local/chromium/run.sh "
		if mode == "youtubetv":
			self.setTitle(_('YouTubeTV'))
			command += "-u %s -x 0 -y 0 " % (config.plugins.browser.youtube_uri.value)
			if config.plugins.browser.youtube_enable_ntpd.value == True:
				command += "-n %s " % (config.plugins.browser.youtube_ntpd_url.value)
			command += "&"
		else :
			self.setTitle(_('ChromiumOS'))
			command += "-c %s " % (config.plugins.browser.startup.value)
			command += "-x %d -y %d " % (config.plugins.browser.margin_x.value, config.plugins.browser.margin_y.value)
			if config.plugins.browser.enable_ntpd.value == True:
				command += "-n %s " % (config.plugins.browser.ntpd_url.value)
			command += "-r %s " % (config.plugins.browser.rcu_type.value)
			command += "&"

		os.system(command)

                self.dvbappLockTimer = eTimer()                                                
                self.dvbappLockTimer.timeout.get().append(self._cb_DvbappLockTimer)            
                self.dvbappLockTimer.start(2000)
		
	def _cb_DvbappLockTimer(self):
		self.dvbappLockTimer.stop()                                                                                                                            
		dvbapp_lock()                                                                                                                                          
                                                                                                                                                               
	def Exit(self):
		if self.isMute :
			VolumeControl.instance.volctrl.volumeMute()
		else :
			VolumeControl.instance.volctrl.volumeUnMute()

		cbcfg.DEBUG("[Chromium Plugin] ==== >> default mute [%d] , restore mute [%d]" % (self.isMute, self.isMute))		

		self.closeTimer.start(1500)

	def _cb_CloseTimer(self):
	        self.closeTimer.stop()                                                                                                                                 
       	                                                                                                                                                        
		self.pServerThread.kill()                                                                                                                              
		self.pServerThread.join()                                                                                                                              
                                                                                                                                                               
		dvbapp_unlock()                                                                                                                                        
                                                                                                                                                               
		if cbcfg.g_service is not None:                                                                                                                  
                	self.session.nav.playService(cbcfg.g_service)                                                                                            
		self.close()

def start_youtubetv_main(session, **kwargs):
        def _cb_youtubetv_close(ret):
       	        if ret:
			dvbapp_unlock()
			cbcfg.g_browser = session.open(BBrowserLauncher, mode="youtubetv")

	if config.plugins.browser.youtube_showhelp.value == True:
		_cb_youtubetv_close(True)
	else:
		session.openWithCallback(_cb_youtubetv_close, YoutubeTVWindow)

def menu_start_youtube(menuid, **kwargs):                                         
        if menuid == "mainmenu":                                                  
       	        return [(_("YouTubeTV"), start_youtubetv_main, "youtubetv", 46)]
        return []

def plugin_setting_youtube(session, **kwargs):                                                                                                                 
        session.open(YoutubeTVSettings)    

def plugin_start_chromiumos(session, **kwargs):
	dvbapp_unlock()
        def _cb_chromiumos_close(ret):
                if ret:
			dvbapp_unlock()
			cbcfg.g_browser = session.open(BBrowserLauncher, mode="chromiumos")
	cbcfg.g_browser = session.openWithCallback(_cb_chromiumos_close, ChromiumOSWindow)

def session_start_main(session, reason, **kwargs):                                                                                                             
	PServerThread.close()

def Plugins(**kwargs):
	l = []
	l.append(PluginDescriptor(where=PluginDescriptor.WHERE_SESSIONSTART, fnc=session_start_main))
	l.append(PluginDescriptor(name=_("YouTubeTV"), where=PluginDescriptor.WHERE_MENU, fnc=menu_start_youtube))
	l.append(PluginDescriptor(name=_("YouTubeTV Settings"), where=PluginDescriptor.WHERE_PLUGINMENU, fnc=plugin_setting_youtube))
	l.append(PluginDescriptor(name=_("ChromiumOS"), description=_("Start ChromiumOS"), where=PluginDescriptor.WHERE_PLUGINMENU, needsRestart=True, fnc=plugin_start_chromiumos))
	return l
