# -*- coding: UTF-8 -*-
# /*
# *      Copyright (C) 2011 Lubomir Kucera
# *
# *
# *  This Program is free software; you can redistribute it and/or modify
# *  it under the terms of the GNU General Public License as published by
# *  the Free Software Foundation; either version 2, or (at your option)
# *  any later version.
# *
# *  This Program is distributed in the hope that it will be useful,
# *  but WITHOUT ANY WARRANTY; without even the implied warranty of
# *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# *  GNU General Public License for more details.
# *
# *  You should have received a copy of the GNU General Public License
# *  along with this program; see the file COPYING.  If not, write to
# *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# *  http://www.gnu.org/copyleft/gpl.html
# *
# */
import re
import util

__author__ = 'Lubomir Kucera'
__name__ = 'exashare'


def supports(url):
    return re.search(r'exashare\.com/embed\-[^\.]+\.html', url) is not None


def resolve(url):
    data = util.request(url)
    playlist = re.search(r'playlist:\s*\[.+?file:\s*\"([^\"]+)\"', data, flags=re.S)
    if playlist:
        stream = {'url': playlist.group(1), 'quality': '360p'}
        tracks = re.search(r'tracks:\s*\[.+?file:\s*\"([^\"]+)\",\s*label:\s*\"([^\"]+)\"',
                           data, flags=re.S)
        if tracks:
            stream['subs'] = tracks.group(1)
            stream['lang'] = ' ' + tracks.group(2) + ' subtitles'
        return [stream]
    return None
