from enigma import eTimer as Timer
try:
    Timer().callback
except AttributeError:
    # eTimer has changed interface on DMM images
    class  eTimer(object):
        def __init__(self):
            self._timer = Timer()
            
        def __getattr__(self, key):
            if key == "callback":
                timeout = self._timer.timeout
                timeout.append = timeout.connect
                return timeout
            else:
                return getattr(self._timer, key)
else:
    eTimer = Timer
    

from enigma import eConsoleAppContainer as ConsoleAppContainer
try:
    ConsoleAppContainer().dataAvail.callback
except AttributeError:
    class  eConsoleAppContainer(object):
        def __init__(self):
            self._container = ConsoleAppContainer()
            
        def __getattr__(self, key):
            if key in ("dataAvail", "appClosed","stderrAvail"):
                cbtype = getattr(self._container, key)
                cbtype.append = cbtype.connect
                return cbtype
            else:
                return getattr(self._container, key)
else:
    eConsoleAppContainer = ConsoleAppContainer
    

from enigma import ePicLoad as PicLoad
try:
    PicLoad.PictureData.get().append
except AttributeError:
    class  ePicLoad(object):
        def __init__(self):
            self._picload = PicLoad()
            
        def __getattr__(self, key):
            if key  == "PictureData":
                picturedata = self._picload.PictureData
                picturedata._get = object()
                picturedata._get.append = picturedata.connect
                picturedata.get = lambda x: picturedata._get
                return picturedata
            else:
                return getattr(self._picload, key)
else:
    ePicLoad = PicLoad
    